﻿using System;
using System.ComponentModel;
using System.Xml.Serialization;
using System.Collections.Generic;
using System.Collections;

namespace PerformanceTesting
{
    [Serializable]
    [XmlType(AnonymousType = true)]
    [XmlRootAttribute(IsNullable = false)]
    public class SerializableException
    {
        #region Members
        private KeyValuePair<object, object>[] _Data;
        private string _HelpLink = string.Empty;
        private SerializableException _InnerException;
        private string _Message = string.Empty;
        private string _Source = string.Empty;
        private string _StackTrace = string.Empty;
        #endregion

        #region Constructors
        public SerializableException()
        {
        }

        public SerializableException(Exception exception)
            : this()
        {
            setValues(exception);
        }
        #endregion

        #region Properties
        public string HelpLink
        {
            get { return _HelpLink; }
            set { _HelpLink = value; }
        }
        public string Message
        {
            get { return _Message; }
            set { _Message = value; }
        }
        public string Source
        {
            get { return _Source; }
            set { _Source = value; }
        }
        public string StackTrace
        {
            get { return _StackTrace; }
            set { _StackTrace = value; }
        }
        public SerializableException InnerException
        {
            get { return _InnerException; }
            set { _InnerException = value; }
        }
        public KeyValuePair<object, object>[] Data
        {
            get { return _Data ?? new KeyValuePair<object, object>[0]; }
            set { _Data = value; }
        }
        #endregion

        #region Private Methods
        private void setValues(Exception exception)
        {
            if (null != exception)
            {
                _HelpLink = exception.HelpLink ?? string.Empty;
                _Message = exception.Message ?? string.Empty;
                _Source = exception.Source ?? string.Empty;
                _StackTrace = exception.StackTrace ?? string.Empty;
                setData(exception.Data);
                _InnerException = new SerializableException(exception.InnerException);
            }
        }

        private void setData(ICollection collection)
        {
            _Data = new KeyValuePair<object, object>[0];

            if (null != collection)
                collection.CopyTo(_Data, 0);
        }
        #endregion
    }
}